
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1190.C - Message 1190 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1190 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1190.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:54   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:43:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:30   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:08:20   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:00   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1190 message from the ZMsgBuf.
//
void Dec1190(tMSGBUF *ZMsgBuf, tMSG1190 *Msg)
{

}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1190 message in the ZMsgBuf. 
//
void Bld1190(tMSGBUF *ZMsgBuf, tMSG1190 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);  // message preamble
   PutShort  (1190                          , ZMsgBuf, 2);  // message number
   PutShort  (7                             , ZMsgBuf, 3);  // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);  // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);  // header check sum
                                                            
 //PutShort  (CheckSum(ZMsgBuf, 6, 7)       , ZMsgBuf,13);  // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1190 message from the ZMsgBuf.
//
void Show1190(tMSG1190 *Msg)
{
   char    Buf[100] = "";
   char    *ErrorName[6] =
            {"USER MODE EXCEPTION", "EXEC MODE EXCEPTION", "TRAP", 
            "EXECUTIVE ERROR", "ESR ERROR", "USER ERROR",}; 

   // perform special processing for output
   sprintf(Buf,"MSG 1190: CLASS: %s NUMBER: %d CENV: %02X PC: %04X",
               ErrorName[(short) Msg->Class],
               Msg->ErrorNumber, Msg->CodeEnviron, Msg->ProgramCounter); 
   
   // output the data items   
   clear_message_line();                                                                                               
   ShowText(Buf, CMDR-1, CMDC);  
   wait(.5f);
}                                                 
                                      
                                           
